import { Link, useLocation } from 'react-router-dom'
import { Library, Facebook, Instagram, Youtube, Phone, Mail, MapPin, Clock } from 'lucide-react'
import './Layout.css'

function Layout({ children }) {
  const location = useLocation()

  return (
    <div className="app">
      <header className="header">
        <div className="header-content">
          <div className="logo">
            <div className="logo-icon">
              <Library className="logo-icon-img" size={32} />
            </div>
            <span className="logo-text">Библиотека</span>
          </div>
          <nav className="nav">
            <Link 
              to="/" 
              className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
            >
              Мои заказы
            </Link>
            <Link 
              to="/book" 
              className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}
            >
              Забронировать
            </Link>
          </nav>
        </div>
      </header>
      <main className="main-content">
        {children}
      </main>
      <footer className="footer">
        <div className="footer-wrapper">
          <div className="footer-main">
            <div className="footer-col">
              <div className="footer-brand">
                <div className="footer-logo">
                  <Library className="footer-logo-icon" size={32} />
                  <h2>Библиотека</h2>
                </div>
                <p>Крупнейшая библиотека города с коллекцией более 500 000 книг. Мы открыты для всех с 1970 года.</p>
                <div className="footer-social">
                  <a href="#" className="social-btn" aria-label="Facebook">
                    <Facebook className="social-icon" size={18} />
                  </a>
                  <a href="#" className="social-btn" aria-label="Instagram">
                    <Instagram className="social-icon" size={18} />
                  </a>
                  <a href="#" className="social-btn" aria-label="Youtube">
                    <Youtube className="social-icon" size={18} />
                  </a>
                </div>
              </div>
            </div>
            <div className="footer-col">
              <h4>Быстрые ссылки</h4>
              <ul>
                <li><Link to="/book">Забронировать онлайн</Link></li>
                <li><a href="#">Каталог книг</a></li>
                <li><a href="#">Новинки</a></li>
                <li><a href="#">Популярные</a></li>
                <li><a href="#">Акции</a></li>
              </ul>
            </div>
            <div className="footer-col">
              <h4>Жанры</h4>
              <ul>
                <li><a href="#">Художественная</a></li>
                <li><a href="#">Научная</a></li>
                <li><a href="#">Учебная</a></li>
                <li><a href="#">Детская</a></li>
                <li><a href="#">Справочная</a></li>
              </ul>
            </div>
            <div className="footer-col">
              <h4>Контакты</h4>
              <div className="footer-contacts">
                <div className="footer-contact-item">
                  <Phone className="contact-icon" size={16} />
                  <div>
                    <span>+7 (495) 123-45-67</span>
                    <span className="contact-label">Справочная</span>
                  </div>
                </div>
                <div className="footer-contact-item">
                  <Mail className="contact-icon" size={16} />
                  <span>info@library.ru</span>
                </div>
                <div className="footer-contact-item">
                  <MapPin className="contact-icon" size={16} />
                  <span>Москва, ул. Книжная, 15</span>
                </div>
                <div className="footer-contact-item">
                  <Clock className="contact-icon" size={16} />
                  <span>Пн-Сб: 9:00 - 20:00</span>
                </div>
              </div>
            </div>
          </div>
          <div className="footer-divider"></div>
          <div className="footer-bottom">
            <p>&copy; 2025 Библиотека. Все права защищены.</p>
            <div className="footer-links-bottom">
              <a href="#">Политика конфиденциальности</a>
              <a href="#">Пользовательское соглашение</a>
              <a href="#">Карта сайта</a>
            </div>
          </div>
        </div>
      </footer>
    </div>
  )
}

export default Layout

